#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include <avr/pgmspace.h>
#include <math.h>

#include "ATMEGA328.h"
#include "SPI.h"
#include "I2C.h"
#include "Sensor.h"

//Constants needed to control the ledstrip//

//First byte of 'LED Frame'
const uint8_t ledframefirst =  ledframestart | brightness;

//Second, third and fourth byte of 'LED frame' (BGR), stored as one byte in (r,theta) matrix form
const uint8_t ledList [numberOfPositions][numberOfLeds] PROGMEM = {{0,0,0,0,0,0,0,250,0,0,0,74,41,41,5,0,0,0,219,5,1,223,0,0,0,41,41,9,9,9,41,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,41,1,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,219,0,0,0,183,5,41,146,0,0,0,150,41,1,223,0,0,0,41,41,9,9,9,41,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,187,37,41,1,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,219,223,0,0,0,1,1,223,0,0,0,78,41,1,223,0,0,0,41,41,9,9,9,41,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,182,41,1,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,37,0,0,0,0,78,5,0,0,0,0,5,41,1,223,0,0,0,41,41,9,9,9,41,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,5,41,146,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,41,114,0,0,0,1,223,0,0,0,74,41,9,1,223,0,0,0,41,41,9,9,9,41,1,0,0,0,0,1,0,0,0,0,0,78,78,110,1,219,0,0,0,0,1,146,0,0,0,0,0,0,0},{0,0,0,0,0,0,219,5,5,0,0,0,150,0,0,0,0,1,41,41,78,0,0,0,0,41,41,9,9,9,41,1,0,0,0,0,1,0,0,0,0,182,5,5,41,41,37,0,0,0,0,1,1,0,0,0,0,0,0,0},{0,0,0,0,0,0,219,5,37,0,0,0,0,0,0,0,219,1,9,41,78,0,0,0,219,41,41,9,9,9,41,1,0,0,0,0,150,150,0,0,0,150,41,5,9,41,37,183,0,0,0,41,1,0,0,0,0,0,0,0},{0,0,0,0,0,0,41,41,78,0,0,0,0,0,0,0,1,41,5,41,78,0,0,0,219,5,41,9,9,9,41,1,0,0,0,0,150,150,0,0,0,150,1,41,9,5,1,0,0,0,0,78,41,146,0,0,0,0,0,0},{0,0,0,0,0,219,5,41,114,0,0,0,0,0,0,37,5,9,5,5,219,0,0,0,219,5,9,9,9,9,41,1,0,0,0,0,150,150,0,0,0,0,1,41,41,5,114,0,0,0,0,41,41,1,0,0,0,0,0,0},{0,0,0,0,219,41,41,41,182,0,0,0,0,0,187,1,41,9,41,5,219,0,0,0,219,5,9,9,9,9,41,1,0,0,0,0,150,1,0,0,0,0,150,5,5,42,223,0,0,0,219,5,9,41,146,0,0,0,0,0},{0,0,0,0,41,41,9,9,187,0,0,0,0,219,1,41,9,9,41,37,0,0,0,0,41,5,9,9,9,9,41,1,150,0,0,0,0,1,0,0,0,0,150,9,223,0,0,0,0,0,5,41,9,41,1,146,0,0,0,0},{0,0,0,41,5,9,9,9,1,110,0,0,74,1,41,9,9,9,41,1,0,0,0,0,41,41,9,9,9,9,41,1,150,0,0,0,0,1,150,0,0,0,0,223,0,0,0,0,0,0,5,9,9,9,41,1,0,0,0,0},{0,0,41,5,9,9,9,9,9,41,5,41,41,41,9,9,9,9,41,146,0,0,0,219,41,41,9,9,9,9,41,1,150,0,0,0,0,150,150,0,0,0,0,0,0,0,0,0,219,1,41,9,9,9,9,41,1,0,0,0},{0,41,5,9,9,9,9,9,9,9,41,41,9,9,9,9,9,9,37,223,0,0,0,219,5,41,9,9,9,9,41,41,150,0,0,0,0,150,1,0,0,0,0,0,0,0,0,0,74,41,9,9,9,9,9,9,41,1,146,0},{41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,0,0,0,0,223,5,41,9,9,9,9,41,41,150,0,0,0,0,0,1,150,0,0,0,0,0,0,0,1,41,9,9,9,9,9,9,9,9,41,41,146},{41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,78,5,9,9,9,9,9,41,41,150,0,0,0,0,0,150,150,0,0,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,9,41},{41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,74,0,0,0,0,114,41,9,9,9,9,9,41,41,150,0,0,0,0,0,150,1,150,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,9,9,5},{5,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,110,0,0,0,0,1,41,9,9,9,9,9,41,41,1,0,0,0,0,0,0,150,1,0,0,0,78,1,9,9,9,9,9,9,9,9,9,9,9,9,9,5},{0,5,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,110,0,0,0,0,41,9,9,9,9,9,9,41,41,1,150,0,0,0,0,0,0,1,150,0,0,1,41,9,9,9,9,9,9,9,9,9,9,9,41,5,219},{0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,9,9,41,219,0,0,0,114,41,9,9,9,9,9,9,41,41,1,150,0,0,0,0,0,0,150,1,150,78,1,9,9,9,9,9,9,9,9,9,9,9,41,5,219,0},{0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,9,41,187,0,0,0,110,41,9,9,9,9,9,9,41,41,1,150,0,0,0,0,0,0,0,150,1,41,41,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0},{0,0,0,219,5,41,9,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,110,41,9,9,9,9,9,9,41,41,1,1,150,0,0,0,0,0,0,0,146,41,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0},{0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,41,219,0,0,0,182,41,9,9,9,9,9,9,41,41,41,1,150,0,0,0,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,41,5,219,0,0,0},{0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,78,41,9,9,9,9,9,9,41,41,41,1,150,150,0,0,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,5,187,0,0,0,5,41,9,9,9,9,9,9,41,41,41,1,1,150,150,0,0,0,0,0,1,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,5,41,9,9,9,9,9,9,41,41,41,41,1,1,150,150,0,0,0,0,1,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,1,0,0,0,0,219,5,9,9,9,9,9,9,41,41,41,41,41,1,1,150,150,150,0,78,1,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,41,146,0,0,0,219,5,5,9,9,9,9,9,41,41,41,41,41,41,41,1,1,1,182,42,41,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,41,114,0,0,0,223,5,5,9,9,9,9,9,41,41,41,41,41,41,41,41,41,41,1,5,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,41,110,0,0,0,0,1,9,9,9,9,9,9,41,41,41,41,41,41,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,41,74,0,0,0,0,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,41,1,0,0,0,0,41,41,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,187,1,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,41,183,0,0,0,0,1,5,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,5,78,0,0,0,0,114,5,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,41,146,0,0,0,0,114,1,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,5,1,0,0,0,0,219,1,1,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0},{0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,9,37,0,0,0,0,0,183,1,41,41,41,9,9,9,9,9,9,9,9,9,9,41,5,5,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0},{0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,0,183,150,1,41,41,9,9,9,9,9,9,9,9,9,41,5,41,9,41,9,9,9,9,9,9,9,9,9,9,41,5,219,0,0,0},{0,0,0,219,5,41,9,9,9,9,9,9,9,9,9,9,9,9,41,41,146,0,0,0,0,0,150,1,41,41,9,9,9,9,9,9,9,9,41,5,41,219,0,1,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0},{0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,5,5,41,41,78,0,0,0,0,0,150,1,41,41,9,9,9,9,9,9,9,41,5,41,219,0,0,78,41,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0},{0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,41,1,146,1,41,5,0,0,0,0,0,0,1,41,41,9,9,9,9,9,9,9,41,5,219,0,0,0,78,1,9,9,9,9,9,9,9,9,9,9,9,41,5,219,0},{0,5,41,9,9,9,9,9,9,9,9,9,9,9,9,1,110,0,150,1,37,110,0,0,0,0,0,150,1,41,9,9,9,9,9,9,41,5,41,219,0,0,0,0,1,41,9,9,9,9,9,9,9,9,9,9,9,41,5,219},{5,41,9,9,9,9,9,9,9,9,9,9,9,9,41,110,0,0,0,150,1,1,0,0,0,0,0,150,1,41,9,9,9,9,9,9,41,41,219,0,0,0,0,0,78,1,9,9,9,9,9,9,9,9,9,9,9,9,9,5},{41,9,9,9,9,9,9,9,9,9,9,9,9,41,1,0,0,0,0,0,150,1,223,0,0,0,0,150,1,41,9,9,9,9,9,41,5,41,0,0,0,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,9,9,9},{1,41,9,9,9,9,9,9,9,9,9,9,9,1,110,0,0,0,0,0,150,1,0,0,0,0,0,150,1,41,9,9,9,9,9,41,5,219,0,0,0,0,0,0,0,0,78,9,9,9,9,9,9,9,9,9,9,9,9,9},{0,1,41,9,9,9,9,9,9,9,9,9,1,110,0,0,0,0,0,0,0,150,110,0,0,0,0,0,1,41,9,9,9,9,9,41,41,219,0,0,0,0,0,0,0,0,37,9,9,9,9,9,9,9,9,9,9,9,9,5},{0,0,146,41,41,9,9,9,9,9,41,5,110,0,0,0,0,0,0,0,0,150,1,0,0,0,0,0,1,41,9,9,9,9,9,5,41,0,0,0,0,0,0,0,0,0,1,41,9,9,9,9,9,9,9,9,9,41,5,219},{0,0,0,146,41,41,9,9,9,9,5,41,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,41,9,9,9,9,9,5,219,0,0,0,0,223,0,0,0,223,41,9,9,9,9,9,9,9,9,9,41,41,219,0},{0,0,0,0,146,41,9,9,5,5,146,0,0,0,0,0,219,150,0,0,0,0,1,150,0,0,0,0,1,41,9,9,9,9,41,5,219,0,0,0,219,183,0,0,0,146,41,9,9,9,9,9,9,9,9,41,41,219,0,0},{0,0,0,0,0,1,41,9,41,183,0,0,0,0,0,219,41,1,0,0,0,0,150,150,0,0,0,0,150,41,9,9,9,9,41,41,219,0,0,0,219,0,0,0,0,5,41,9,9,9,9,9,9,9,41,5,219,0,0,0},{0,0,0,0,0,0,1,41,5,0,0,0,0,0,219,9,5,1,0,0,0,0,150,1,0,0,0,0,150,41,9,9,9,9,41,41,0,0,0,0,73,0,0,0,0,1,41,9,9,9,9,9,9,9,5,41,0,0,0,0},{0,0,0,0,0,0,146,41,183,0,0,0,0,114,5,41,41,41,150,0,0,0,0,1,0,0,0,0,150,41,9,9,9,9,41,41,0,0,0,0,77,0,0,0,0,5,41,9,9,9,9,9,9,1,183,196,205,0,0,0},{0,0,0,0,0,0,0,1,219,0,0,0,219,1,41,9,9,41,150,0,0,0,0,1,0,0,0,0,150,41,9,9,9,9,41,41,0,0,0,223,1,0,0,0,0,1,9,9,9,9,9,9,1,187,246,200,200,236,205,0},{0,0,0,0,0,0,0,146,219,0,0,0,1,41,9,9,9,41,1,0,0,0,0,1,0,0,0,0,150,41,9,9,9,9,5,41,0,0,0,223,1,0,0,0,0,5,41,9,9,9,9,5,183,0,196,200,232,246,0,0},{0,0,0,0,0,0,0,146,150,0,0,0,110,41,9,9,9,41,1,0,0,0,0,150,150,0,0,0,150,41,9,9,9,9,5,219,0,0,0,223,1,219,0,0,0,1,9,9,9,9,5,183,0,0,196,232,246,0,0,0},{0,0,0,0,0,0,0,0,187,0,0,0,110,41,9,9,41,41,1,150,0,0,0,150,150,0,0,0,150,41,9,9,9,9,5,219,0,0,0,78,5,0,0,0,0,5,41,9,9,41,1,0,0,242,232,246,0,0,0,0},{0,0,0,0,0,0,0,0,183,0,0,0,0,73,1,5,5,41,41,150,0,0,0,150,150,0,0,0,150,41,9,9,9,9,5,219,0,0,0,78,1,0,0,0,0,1,9,9,9,5,223,0,0,242,200,0,0,0,0,0},{0,0,0,0,0,0,0,0,146,0,0,0,0,0,182,78,223,223,223,0,0,0,0,150,150,0,0,0,150,41,9,9,9,9,5,219,0,0,0,78,5,219,0,0,0,5,41,9,41,5,0,0,0,200,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,146,114,0,0,0,0,0,0,0,0,0,0,0,0,0,150,150,0,0,0,150,41,9,9,9,9,5,219,0,0,0,78,41,182,0,0,0,146,41,9,5,146,0,0,0,246,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,223,1,5,5,187,0,0,0,9,41,78,0,0,0,219,5,9,9,9,9,41,150,0,0,0,150,150,0,0,0,0,0,0,0,0,0,0,0,0,187,5,146,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,219,0,0,0,5,41,1,0,0,0,0,1,41,78,0,0,0,219,5,9,9,9,9,41,150,0,0,0,150,150,0,0,0,0,0,0,0,0,0,0,0,110,41,41,146,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,78,0,0,0,146,41,78,0,0,0,223,1,41,110,0,0,0,219,5,9,9,9,9,41,150,0,0,0,150,150,0,0,0,0,0,0,0,0,0,0,0,187,1,41,146,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,219,146,0,0,0,219,1,187,0,0,0,187,5,41,78,0,0,0,219,5,9,9,9,9,41,150,0,0,0,150,150,0,0,0,0,0,0,0,0,0,0,0,0,183,5,1,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,219,1,0,0,0,187,146,0,0,0,219,5,41,41,78,0,0,0,219,5,9,9,9,9,41,150,0,0,0,150,150,0,0,0,0,0,78,78,1,74,0,0,0,0,110,1,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,41,5,219,0,0,0,183,0,0,0,183,41,9,1,223,0,0,0,219,5,9,9,9,9,41,150,0,0,0,150,150,0,0,0,0,1,5,41,41,37,187,0,0,0,146,1,146,0,0,0,0,0,0,0},{0,0,0,0,0,0,41,37,187,0,0,0,0,0,0,0,41,41,9,1,223,0,0,0,41,5,9,9,9,9,41,150,0,0,0,0,1,0,0,0,0,1,41,9,9,41,5,0,0,0,0,5,146,0,0,0,0,0,0,0},{0,0,0,0,0,219,5,1,219,0,0,0,0,0,0,110,41,9,5,1,223,0,0,0,41,41,9,9,9,9,41,150,0,0,0,0,1,0,0,0,0,150,41,9,9,41,183,0,0,0,0,1,1,0,0,0,0,0,0,0},{0,0,0,0,0,41,41,5,0,0,0,0,0,0,146,37,41,9,41,74,0,0,0,0,41,41,9,9,9,9,41,150,0,0,0,0,1,0,0,0,0,150,41,41,41,5,219,0,0,0,0,5,41,146,0,0,0,0,0,0},{0,0,0,0,41,5,9,1,0,0,0,0,0,187,78,41,9,5,41,73,0,0,0,0,41,41,9,9,9,9,41,150,0,0,0,0,1,150,0,0,0,0,1,5,41,223,0,0,0,0,219,41,41,1,0,0,0,0,0,0},{0,0,0,219,5,41,9,5,0,0,0,0,183,74,41,9,9,9,37,219,0,0,0,219,41,41,9,9,9,9,41,150,0,0,0,0,150,150,0,0,0,0,1,74,223,0,0,0,0,0,5,9,9,41,1,0,0,0,0,0},{0,0,219,41,41,9,9,41,1,110,0,219,1,5,9,9,9,9,1,183,0,0,0,219,5,41,9,9,9,9,41,1,0,0,0,0,150,1,0,0,0,0,150,223,0,0,0,0,0,37,41,9,9,9,41,146,0,0,0,0},{0,219,41,41,9,9,9,9,41,1,78,1,41,9,9,9,9,41,1,0,0,0,0,219,5,9,9,9,9,9,41,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,5,41,9,9,9,9,41,41,146,0,0,0},{219,5,41,9,9,9,9,9,9,9,9,41,9,9,9,9,9,9,5,0,0,0,0,41,5,9,9,9,9,9,41,1,0,0,0,0,0,1,150,0,0,0,0,0,0,0,0,78,5,41,9,9,9,9,9,41,41,146,0,0},{5,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,114,0,0,0,223,42,41,9,9,9,9,9,41,1,0,0,0,0,0,150,150,0,0,0,0,0,0,0,78,1,9,9,9,9,9,9,9,9,9,41,1,0},{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,0,0,0,0,0,5,41,9,9,9,9,9,41,1,150,0,0,0,0,0,1,150,0,0,0,0,0,78,1,9,9,9,9,9,9,9,9,9,9,9,41,1},{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,183,0,0,0,114,1,41,9,9,9,9,9,41,1,150,0,0,0,0,0,150,150,0,0,0,0,0,1,41,9,9,9,9,9,9,9,9,9,9,9,9,41},{5,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,219,0,0,0,183,41,9,9,9,9,9,9,41,1,150,0,0,0,0,0,150,1,150,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,9,9,41,5},{219,5,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,1,223,0,0,0,5,41,9,9,9,9,9,9,41,1,150,0,0,0,0,0,0,150,1,150,0,78,1,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0},{0,219,5,41,9,9,9,9,9,9,9,9,9,9,9,9,9,1,0,0,0,223,1,9,9,9,9,9,9,9,41,41,1,0,0,0,0,0,0,0,150,1,146,1,41,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0},{0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,1,9,9,9,9,9,9,9,41,41,1,150,0,0,0,0,0,0,0,182,5,5,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0},{0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,41,5,9,9,9,9,9,9,41,41,1,150,0,0,0,0,0,0,0,0,41,9,9,9,9,9,9,9,9,9,9,9,41,5,219,0,0,0},{0,0,0,219,5,41,9,9,9,9,9,9,9,9,9,9,9,41,0,0,0,0,5,5,9,9,9,9,9,9,41,41,1,150,150,0,0,0,0,0,0,0,1,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0},{0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,41,146,0,0,0,0,5,9,9,9,9,9,9,9,41,41,41,1,150,0,0,0,0,0,0,0,1,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0},{0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,5,9,9,9,9,9,9,9,41,41,41,1,1,150,0,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,41,41,0,0,0,219,5,41,9,9,9,9,9,9,41,41,41,41,1,1,150,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,41,110,0,0,0,0,5,41,9,9,9,9,9,9,41,41,41,41,41,1,1,150,150,0,0,78,41,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,1,0,0,0,0,5,41,9,9,9,9,9,9,41,41,41,41,41,41,1,1,1,150,146,5,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,1,0,0,0,0,41,41,9,9,9,9,9,9,41,41,41,41,41,41,41,41,41,1,1,41,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,1,0,0,0,0,146,41,5,9,9,9,9,9,41,41,41,41,41,41,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,5,0,0,0,0,219,5,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,41,150,0,0,0,219,5,41,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0,0},{0,0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,41,78,0,0,0,0,41,5,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,41,1,0,0,0,0,41,5,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,5,223,0,0,0,219,41,41,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0,0},{0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,1,0,0,0,0,0,41,1,41,41,41,41,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,41,150,0,0,0,0,183,1,1,41,41,41,9,9,9,9,9,9,9,9,9,9,9,41,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0,0},{0,0,0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,9,9,5,0,0,0,0,183,182,1,41,41,41,9,9,9,9,9,9,9,9,9,9,41,5,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0,0,0},{0,0,0,219,5,41,9,9,9,9,9,9,9,9,9,9,9,9,5,5,0,0,0,0,0,182,1,41,41,41,9,9,9,9,9,9,9,9,41,41,5,41,5,9,9,9,9,9,9,9,9,9,9,9,5,219,0,0,0,0},{0,0,0,5,41,9,9,9,9,9,9,9,9,9,9,9,41,41,41,5,223,0,0,0,0,182,1,1,41,41,9,9,9,9,9,9,9,41,41,5,41,219,78,41,9,9,9,9,9,9,9,9,9,9,41,5,219,0,0,0},{0,0,219,5,9,9,9,9,9,9,9,9,9,9,9,41,74,1,41,41,78,0,0,0,0,0,150,1,41,41,9,9,9,9,9,9,9,41,5,41,219,0,78,1,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0,0},{0,219,5,41,9,9,9,9,9,9,9,9,9,9,9,1,110,150,1,41,5,0,0,0,0,0,150,1,41,41,9,9,9,9,9,9,41,5,41,219,0,0,0,1,41,9,9,9,9,9,9,9,9,9,9,9,41,5,0,0},{219,5,41,9,9,9,9,9,9,9,9,9,9,9,41,1,0,0,150,1,110,0,0,0,0,0,150,1,41,41,9,9,9,9,9,9,41,41,219,0,0,0,0,78,1,9,9,9,9,9,9,9,9,9,9,9,9,41,5,0},{5,9,9,9,9,9,9,9,9,9,9,9,9,9,1,110,0,0,0,1,1,219,0,0,0,0,0,1,41,41,9,9,9,9,9,41,5,41,0,0,0,0,0,0,78,41,9,9,9,9,9,9,9,9,9,9,9,9,41,5},{9,9,9,9,9,9,9,9,9,9,9,9,9,41,110,0,0,0,0,150,1,5,0,0,0,0,0,150,41,41,9,9,9,9,9,41,41,219,0,0,0,0,0,0,0,1,41,9,9,9,9,9,9,9,9,9,9,9,9,41},{41,9,9,9,9,9,9,9,9,9,9,9,41,110,0,0,0,0,0,0,150,78,0,0,0,0,0,150,41,41,9,9,9,9,9,5,41,219,0,0,0,0,0,0,0,78,5,9,9,9,9,9,9,9,9,9,9,9,9,41},{146,41,41,9,9,9,9,9,9,9,9,41,1,0,0,0,0,0,0,0,150,1,0,0,0,0,0,150,41,41,9,9,9,9,41,5,219,0,0,0,0,0,0,0,0,183,5,9,9,9,9,9,9,9,9,9,9,9,41,41},{0,146,1,41,9,9,9,9,9,9,41,78,0,0,0,0,0,0,0,0,0,1,146,0,0,0,0,150,41,41,9,9,9,9,41,5,219,0,0,0,0,0,0,0,0,146,41,9,9,9,9,9,9,9,9,9,9,5,41,0},{0,0,0,1,41,9,9,9,9,41,5,0,0,0,0,0,0,0,0,0,0,150,146,0,0,0,0,150,1,41,9,9,9,9,41,41,219,0,0,0,219,0,0,0,0,37,41,9,9,9,9,9,9,9,9,9,5,41,0,0},{0,0,0,0,1,41,9,9,41,1,0,0,0,0,0,0,219,0,0,0,0,150,1,0,0,0,0,150,1,41,9,9,9,9,41,41,0,0,0,0,146,0,0,0,0,1,9,9,9,9,9,9,9,9,9,5,41,0,0,0},{0,0,0,0,146,1,41,9,5,183,0,0,0,0,0,219,1,150,0,0,0,0,1,0,0,0,0,150,1,41,9,9,9,9,5,41,0,0,0,0,78,0,0,0,0,5,9,9,9,9,9,9,9,9,41,41,0,0,0,0},{0,0,0,0,0,146,41,41,146,0,0,0,0,219,9,5,37,150,0,0,0,0,1,150,0,0,0,0,1,41,9,9,9,9,5,219,0,0,0,223,146,0,0,0,146,41,9,9,9,9,9,9,9,41,41,219,0,0,0,0},{0,0,0,0,0,0,1,5,0,0,0,0,0,78,5,41,41,1,0,0,0,0,150,150,0,0,0,0,1,41,9,9,9,9,5,219,0,0,0,223,78,0,0,0,0,5,9,9,9,9,9,9,41,41,209,200,205,0,0,0},{0,0,0,0,0,0,146,78,0,0,0,0,78,41,9,9,41,1,150,0,0,0,150,150,0,0,0,0,1,41,9,9,9,41,5,219,0,0,0,110,187,0,0,0,146,41,9,9,9,9,9,41,1,0,196,200,232,200,251,0},{0,0,0,0,0,0,0,41,0,0,0,219,41,5,9,9,9,41,150,0,0,0,150,150,0,0,0,0,1,41,9,9,9,41,41,219,0,0,0,110,146,0,0,0,5,5,9,9,9,9,41,5,0,242,200,200,196,0,0,0},{0,0,0,0,0,0,0,150,0,0,0,0,1,9,9,9,9,41,150,0,0,0,0,1,0,0,0,0,1,41,9,9,9,41,41,0,0,0,0,110,78,0,0,0,146,41,9,9,9,41,5,0,0,242,236,200,0,0,0,0},{0,0,0,0,0,0,0,146,0,0,0,0,1,41,9,41,41,41,1,0,0,0,0,1,0,0,0,0,1,41,9,9,9,41,41,0,0,0,223,1,183,0,0,0,219,5,9,9,9,41,146,0,0,200,200,0,0,0,0,0},{0,0,0,0,0,0,0,146,0,0,0,0,219,1,5,5,5,42,5,0,0,0,0,1,0,0,0,0,1,41,9,9,9,41,41,0,0,0,223,5,114,0,0,0,146,41,9,9,41,74,223,0,0,196,250,0,0,0,0,0},{0,0,0,0,0,0,0,0,78,0,0,0,0,223,110,223,223,223,219,0,0,0,0,1,0,0,0,0,1,41,9,9,9,41,41,0,0,0,223,5,41,0,0,0,187,5,9,9,1,183,0,0,242,251,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,41,9,9,9,41,41,0,0,0,223,5,1,0,0,0,0,1,41,41,5,0,0,0,209,0,0,0,0,0,0,0}};
const uint8_t ledList2 [numberOfPositions][numberOfLeds] PROGMEM = {{0,0,0,0,0,0,0,0,0,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,109,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,36,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,236,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,236,236,204,204,236,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,236,204,204,204,204,204,204,132,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,236,0,219,0,0,0,0},{0,0,0,0,0,0,0,0,73,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,204,200,0,146,0,0,0},{0,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0},{0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,0,0,0,0},{0,0,0,0,0,0,0,0,0,5,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,0,0,0},{0,0,0,0,0,0,0,0,0,10,5,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0},{0,0,0,0,0,0,0,182,0,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0},{0,0,0,0,0,0,0,219,5,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,132,0,182},{0,0,0,0,0,0,0,0,0,10,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,182,0},{0,0,0,0,0,0,36,0,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0},{0,0,0,0,0,0,0,5,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,132,0,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0},{0,0,0,0,0,0,5,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0},{0,0,0,0,182,0,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0},{0,0,0,0,0,5,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0},{0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0},{0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0},{0,0,146,0,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0},{0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0,0,0,0,0,0},{0,219,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{36,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,219,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,219,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0,0,0,0,0,0},{0,0,109,0,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0},{0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0},{0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,5,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0},{0,0,0,0,109,0,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,132,0,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0},{0,0,0,0,0,0,0,0,5,10,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,182,0},{0,0,0,0,0,0,0,146,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,132,0,182},{0,0,0,0,0,0,0,109,0,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0},{0,0,0,0,0,0,0,0,0,10,5,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,168,0},{0,0,0,0,0,0,0,0,0,5,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0},{0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,204,204,204,204,236,136,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,204,204,204,100,0,219,0,0,0},{0,0,0,0,0,0,0,0,73,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,236,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,182,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,168,236,204,204,204,204,204,204,32,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,168,236,236,204,204,236,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,168,236,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,109,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,73,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,219,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,236,32,73,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,236,204,204,204,100,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,236,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,236,204,204,204,204,204,204,204,204,168,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,109,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,204,204,204,0,109,0,0,0},{0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,73,0,0},{0,0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,36,0},{0,0,0,0,0,0,0,146,0,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,36},{0,0,0,0,0,0,0,0,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,132,0},{0,0,0,0,0,0,219,0,5,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0},{0,0,0,0,0,0,0,0,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0},{0,0,0,0,0,0,36,0,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0},{0,0,0,0,0,0,0,5,10,10,10,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0,0},{0,0,0,0,0,36,0,10,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0},{0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0},{0,0,0,0,0,9,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0},{0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0},{0,0,182,0,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0,0,0,0,0,0,0},{0,0,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0,0},{73,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0,0},{0,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0,0},{73,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0,0},{0,0,9,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0,0},{0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,0,146,0,10,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0,0},{0,0,0,182,0,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0,0},{0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,5,10,10,10,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0,0,0},{0,0,0,0,0,0,0,10,10,10,10,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0,0},{0,0,0,0,0,0,0,0,10,10,10,10,10,10,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0,0},{0,0,0,0,0,0,0,0,10,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,132,0,182,0,0},{0,0,0,0,0,0,146,0,10,10,10,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,0,0,0},{0,0,0,0,0,0,0,0,10,10,10,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,236,136,0},{0,0,0,0,0,0,0,36,0,10,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,168,0,109},{0,0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,168,0,109,0},{0,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,204,204,204,204,204,204,136,0,146,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,204,204,204,204,236,0,182,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,204,204,204,204,236,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,236,204,204,204,204,204,204,204,204,68,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,236,204,204,204,204,204,204,236,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,168,236,204,204,204,0,73,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,168,236,0,146,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,146,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};

// Volatile static variables modified by an interrupt service routine
static volatile uint16_t resetval = 0;
static volatile uint16_t theta = 0;

static volatile uint8_t RecalcVelocity = 0; 
static volatile uint8_t SScheck = 0;

static volatile float secondscounter = 0;
static volatile float secondscounter2 = 0;
static volatile uint8_t Image = 1;


//FUNCTIONS USED IN MAIN//
void LED_Data_spi (const uint8_t list[numberOfPositions][numberOfLeds], uint16_t theta)
{
	uint8_t j = 0;
	uint8_t r,g,b = 0;
	
	for (uint8_t i = 0;i<4;i++)
	{
		//Send start frame of 32 zeros
		spi_tranceiver(zerosbyte);
	}
	
	if (theta < 180)
	{
		for (uint8_t i = 0;i<numberOfLeds;i++)
		{
			//Send 4 bytes: Brightness, Blue, Green, Red
			
			j = theta / restheta;
			
			//Extract 3 RGB values from the one byte
			r = ( pgm_read_byte(&(list[j][i])) ) & 0b11100000;
			g = (( pgm_read_byte(&(list[j][i])) ) & 0b00011100) << 3;
			b = (( pgm_read_byte(&(list[j][i])) ) & 0b00000011) << 6;
			
			//Divide r,g,b by 2 to lower the brightness
			spi_tranceiver(ledframefirst);
			spi_tranceiver(b/2);
			spi_tranceiver(g/2);
			spi_tranceiver(r/2);
		}
	}
	else
	// After 180 degrees, the strip is in the same position but led0 becomes led59
	// Offset is taken into account
	{
		for (int8_t i = numberOfLeds-1;i>-1;i--)
		{
			//Send 4 bytes: Brightness, Blue, Green, Red
			
			j = theta / restheta;
			
			r = ( pgm_read_byte(&(list[j][i])) ) & 0b11100000;
			g = (( pgm_read_byte(&(list[j][i])) ) & 0b00011100) << 3;
			b = (( pgm_read_byte(&(list[j][i])) ) & 0b00000011) << 6;
			
			spi_tranceiver(ledframefirst);
			spi_tranceiver(b/2);
			spi_tranceiver(g/2);
			spi_tranceiver(r/2);
		}
		
	}
	
	for (uint8_t i = 0;i<4;i++)
	{
		//Send stop frame of ones to prolong the clock signal (at least 30 bits of ones = 4 bytes of ones)
		spi_tranceiver(onesbyte);
	}
	
}

int16_t Averaging(float number, uint16_t N)
{
	
	static uint8_t counter = 0;
	static float mean = 0;
	
	counter = counter + 1;
	if (counter == 1){
		mean = number;
	}	
	else {
		mean=(number+mean)/2;
	}

	if (counter == N)
	{
		uint16_t average = mean;
		mean = 0;
		counter = 0;
		return average;
	}
	else
	{
		return -1;
	}
}

int16_t velocitySS(int16_t TH)
{
	int16_t valuez = 0;
	float calcz = 0;
	static float prevV = 0;
	static float nextV = 0;
	
	if (sensor_checkGyro)
	{
			//READ GYRO DATA
			char dest[2];
			sensor_readGyroZ(dest);

			valuez = (dest[1] << 8) | dest[0];
			calcz = valuez * 0.07;

			nextV = prevV;
			prevV = calcz;
			
			if   (abs(calcz) > 100) // Make sure we are moving 
			{
				if (abs(nextV - prevV) > TH)
				{
					return calcz;
				}
				else
				{
					return -1;
				}

			}
			else
			{
				return -1;
			}
	}
}

void timerCalc(int16_t averagevelocity)
{
	float x = restheta; 
	float f = (-1) * averagevelocity/x; // -1 because we measure a negative velocity
	resetval = 65535 - (F_CPU/f); // Prescaler = 1, 16 bit timer
	
}

void initTimer(void)
{
		/* Timer1 clock = I/O clock / 1 */
		TCCR1B =  (1<<CS10);

		/* Timer2 clock = I/O clock / 1024 */
		TCNT2 = 100;
		TCCR2B = (1<<CS22)|(1<<CS20);
		TIMSK2 = 1<<TOIE2;
}

void checkH(float THX, float THY, float THZ)
{
	if (sensor_checkMagn)
	{
	//READ MAGNETO DATA
	char dest[6];
	sensor_readMagn(dest);
	int16_t magxint = (dest[1] << 8) | dest[0];
	float magx = (magxint * 0.00014);
	int16_t magyint = (dest[3] << 8) | dest[2];
	float magy = (magyint * 0.00014);
	int16_t magzint = (dest[5] << 8) | dest[4];
	float magz = (magzint * 0.00014);
	
		if (((abs(magx) > THX)) && ((abs(magy) > THY)) && ((abs(magz) > THZ)))
		{
			theta = thetastart;
			TIMSK1 = 1<<TOIE1;
		}		
	}
}


//MAIN//
int main(void)
{
	spi_init_master();
    sensor_initCommunication();
    sensor_initAccel();
	sensor_initGyro();
	sensor_initMagn();
	initTimer();
	
	//Wait for steady state
	int16_t SS = velocitySS(20);
	while (SS == -1)
	{	
		if (SScheck == 1)
		{
			SS = velocitySS(20);
			SScheck = 0;
		}
	}
	
	while (1)
	{	
		//Recalculate velocity sometimes
		if (RecalcVelocity == 1) 
		{
			//Average out to reduce noise
			int16_t averageSS = -1;
			while (averageSS == -1)
			{
				if (sensor_checkGyro)
				{
					//READ GYRO DATA
					char dest[2];
					sensor_readGyroZ(dest);

					int16_t valuez = (dest[1] << 8) | dest[0];
					float calcz = valuez * 0.07;
					
					averageSS = Averaging(calcz,20);
				}
			}
			
			//Calculate time for strip to move restheta degrees
			timerCalc(averageSS);
			RecalcVelocity = 0;
		}
		//Check if magnet is passed
		checkH(2,2.5,2);
	}
}


//INTERRUPTS//
ISR (TIMER1_OVF_vect)
{
	TCNT1 = resetval;
	theta = theta + restheta;
	if (theta == 360)
	{
		theta = 0;
	}
	if (Image == 1)
	{
		LED_Data_spi(ledList,theta);
	}
	else 
	{
		LED_Data_spi(ledList2,theta);
	}
	
}

ISR (TIMER2_OVF_vect)
{
	TCNT2 = 100; 
	secondscounter = secondscounter + 1;
	if (secondscounter == 1000)
	{
		RecalcVelocity = 1;
		SScheck = 1;
		secondscounter = 0;
		secondscounter2 = secondscounter2 + 1;
	}
	if (secondscounter2 == 5)
	{
		Image = Image * (-1);
		secondscounter2 = 0;
	}
}